import java.util.*;

public class Cylinder {
	private static final int ITER = 20000000;
	private float radius;

	public Cylinder(float r) {
		radius= r;
	}
	
	public float circularIntegral() {
		float sum= 0.0F;
		for (int i=0; i < ITER; i++) {
			// Math.random() returns double d: 0 <= d <= 1
			float x= 2*radius*(float)Math.random() - radius;  // Ctr at 0,0
			float y= 2*radius*(float)Math.random() - radius;
			float f= 1.0F;		// f(x,y)constant here
			if ((x*x + y*y) < radius*radius) // If in region
				sum += f;		// Increment integral sum
		}
        System.out.println("radius "+ radius + " integral " + 4.0F*sum/ITER);
		return 4.0F*sum/ITER;	// Integral value * 4 (pi)
	}    

	public static void main(String[] args) {
		Scanner in= new Scanner(System.in);
		float integral= 0.0F;
		for (int i= 0; i < 6; i++) {
			System.out.println("Enter radius ");
			float radius= in.nextFloat();
			Cylinder t = new Cylinder(radius);
			integral += t.circularIntegral();
		}
		System.out.println("integral " + integral);
		System.out.println("Done");
	}
}